@extends('layouts.app')

@section('title', 'نتائج البحث')

@section('content')
<main>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />

<!-- before closing body: swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>

<div class="swiper-container it-hero-swiper" dir="rtl">
  <div class="swiper-wrapper">
    {{-- Exemple dynamique --}}
    @if(isset($sliders) && $sliders->count())
      @foreach($sliders as $slider)
        <div class="swiper-slide" style="background-image:url('{{ asset('uploads/' . $slider->image) }}'); background-size:cover; background-position:center;">
          <div class="swiper-slide-overlay" style="background: rgba(0,0,0,0.35); padding:80px 0;">
            <div class="container">
              <div class="row align-items-center">
                <div class="col-lg-7">
                  <h4 class="text-light">{{ $slider->soustitre_ar }}</h4>
                  <h1 class="text-white">{{ $slider->titre_ar }}</h1>
                  @if($slider->titre_bouton_ar && $slider->lien_bouton_ar)
                    <a href="{{ $slider->lien_bouton_ar }}" class="btn btn-danger mt-3">{{ $slider->titre_bouton_ar }}</a>
                  @endif
                </div>
                <div class="col-lg-5">
                  {{-- tu peux ajouter le formulaire de recherche ici --}}
                </div>
              </div>
            </div>
          </div>
        </div>
      @endforeach
    @else
      {{-- Exemple statique si pas de sliders --}}
      <div class="swiper-slide" style="background-image:url('{{ asset('images/hero-1.jpg') }}');">
        <div class="swiper-slide-overlay" style="background: rgba(0,0,0,0.35); padding:80px 0;">
          <div class="container">
            <div class="row align-items-center">
              <div class="col-lg-7">
                <h1 class="text-white">عنوان افتراضي للشريط</h1>
                <p class="text-light">نص توضيحي قصير يشرح الهدف.</p>
              </div>
              <div class="col-lg-5">
                {{-- recherche --}}
              </div>
            </div>
          </div>
        </div>
      </div>
      {{-- ajoute d'autres slides si besoin --}}
    @endif
  </div>

  <!-- pagination / navigation -->
  <div class="swiper-pagination"></div>
  <div class="swiper-button-prev"></div>
  <div class="swiper-button-next"></div>
</div>


<style>
    .it-hero-swiper { height: 510px; position: relative; }
.it-hero-swiper .swiper-slide { display:flex; align-items:center; }
.swiper-slide-overlay { width:100%; height:100%; display:flex; align-items:center; }
.it-hero-swiper .swiper-pagination-bullet { background: #fff; opacity: .9; }
.it-hero-swiper .swiper-button-prev, .it-hero-swiper .swiper-button-next { color:#fff; }
@media (max-width: 768px) {
  .it-hero-swiper { height: 320px; }
}
.result-card { border: 1px solid rgba(0,0,0,0.05); transition: transform .18s ease, box-shadow .18s ease; direction: rtl; }
    .result-card:hover { transform: translateY(-6px); box-shadow: 0 12px 24px rgba(0,0,0,0.08); }
    .text-truncate-3 { display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden; }
    mark { background: #ffd54f; padding: 0 .15rem; border-radius: .15rem; color: #222; }
    .section-title { font-weight: 700; }

</style>


<script>
  document.addEventListener('DOMContentLoaded', function () {
    const swiper = new Swiper('.it-hero-swiper', {
      loop: true,
      autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
      speed: 800,
      pagination: {
        el: '.swiper-pagination',
        clickable: true
      },
      navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev'
      },
      effect: 'slide',
      grabCursor: true,
      // accessibility
      a11y: true,
    });
  });
</script>


<div class="container mt-5" dir="rtl">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="mb-0">نتائج البحث عن: <span class="text-danger">{{ $query }}</span></h3>
        <small class="text-muted">إجمالي النتائج:
            {{ $news->count() + $trophees->count() + $guides->count() }}
        </small>
    </div>

    @if($news->isEmpty() && $trophees->isEmpty() && $guides->isEmpty())
        <div class="alert alert-info text-center">لم يتم العثور على نتائج.</div>
    @else
        <div class="row gy-4">
            {{-- News --}}
            @if($news->count())
                <div class="col-12">
                    <h4 class="section-title text-danger mb-3">📰 الأخبار</h4>
                </div>
                @foreach($news as $item)
                    <div class="col-md-6 col-lg-4">
                        <article class="card result-card h-100">
                            <div class="card-body d-flex flex-column">
                                {{-- Si tu as une image miniature, afficher ici --}}
                                @if(!empty($item->thumbnail))
                                    <img src="{{ asset($item->thumbnail) }}" alt="" class="mb-3 rounded" style="width:100%; height:160px; object-fit:cover;">
                                @endif

                                <h5 class="card-title mb-1">
                                    <a href="{{ route('news.show', $item->slug) }}" class="stretched-link text-decoration-none">
                                        {!! highlight($item->title, $query) !!}
                                    </a>
                                </h5>

                                <small class="text-muted mb-2">{{ $item->created_at->format('Y-m-d') }}</small>

                                <p class="card-text mb-3 text-truncate-3">
                                    {!! highlight(strip_tags($item->excerpt ?? \Illuminate\Support\Str::limit($item->content, 150)), $query) !!}
                                </p>

                                <div class="mt-auto d-flex justify-content-between align-items-center">
                                    <span class="badge bg-danger">الأخبار</span>
                                    <a href="{{ route('news.show', $item->slug) }}" class="btn btn-sm btn-outline-primary">قراءة المزيد</a>
                                </div>
                            </div>
                        </article>
                    </div>
                @endforeach
            @endif

            {{-- Trophées --}}
            @if($trophees->count())
                <div class="col-12">
                    <h4 class="section-title text-success mb-3">🏆 التتويجات الرياضية</h4>
                </div>
                @foreach($trophees as $item)
                    <div class="col-md-6 col-lg-4">
                        <article class="card result-card h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title mb-1">
                                    <a href="{{ route('trophees.show', $item->slug) }}" class="stretched-link text-decoration-none">
                                        {!! highlight($item->title, $query) !!}
                                    </a>
                                </h5>

                                <small class="text-muted mb-2">{{ $item->created_at->format('Y-m-d') }}</small>

                                <p class="card-text mb-3 text-truncate-3">
                                    {!! highlight(strip_tags($item->excerpt ?? \Illuminate\Support\Str::limit($item->description ?? '', 140)), $query) !!}
                                </p>

                                <div class="mt-auto d-flex justify-content-between align-items-center">
                                    <span class="badge bg-success">التتويجات</span>
                                    <a href="{{ route('trophees.show', $item->slug) }}" class="btn btn-sm btn-outline-primary">تفاصيل</a>
                                </div>
                            </div>
                        </article>
                    </div>
                @endforeach
            @endif

            {{-- Guides --}}
            @if($guides->count())
                <div class="col-12">
                    <h4 class="section-title text-primary mb-3">📚 الأدلة</h4>
                </div>
                @foreach($guides as $item)
                    <div class="col-md-6 col-lg-4">
                        <article class="card result-card h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title mb-2">
                                    <a href="#" class="stretched-link text-decoration-none">
                                        {!! highlight($item->titre_G, $query) !!}
                                    </a>
                                </h5>

                                <p class="card-text mb-3 text-truncate-3">
                                    {!! highlight(strip_tags($item->excerpt ?? \Illuminate\Support\Str::limit($item->description ?? '', 140)), $query) !!}
                                </p>

                                <div class="mt-auto d-flex justify-content-between align-items-center">
                                    <span class="badge bg-primary">دليل</span>
                                    <a href="#" class="btn btn-sm btn-outline-primary">عرض</a>
                                </div>
                            </div>
                        </article>
                    </div>
                @endforeach
            @endif
        </div>
    @endif
</div>
</main>

{{-- Styles locaux (déplace dans ton CSS si nécessaire) --}}
@push('styles')
<style>
    .result-card { border: 1px solid rgba(0,0,0,0.05); transition: transform .18s ease, box-shadow .18s ease; direction: rtl; }
    .result-card:hover { transform: translateY(-6px); box-shadow: 0 12px 24px rgba(0,0,0,0.08); }
    .text-truncate-3 { display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden; }
    mark { background: #ffd54f; padding: 0 .15rem; border-radius: .15rem; color: #222; }
    .section-title { font-weight: 700; }
</style>
@endpush

@endsection
